
--Variables
doBatch = true
fixMats = true -- fix spec and diffuse
indexMat = true -- add index #s required for Cal3d

--Define Functions

fn scriptStarted = --to run at start of script
(
	disableSceneRedraw() 
) --end scriptStarted

fn setMatScript =
(
scriptStarted()

if doBatch == true then 
	(
	thePath = getSavePath() --get a path dialog to specify the path
	if thePath != undefined do --if the user did not cancel
		(
		theFiles = getFiles (thePath+"\\*.max") --collect all max files in the dir.
			
		fileCountdown = undefined
		for f in theFiles do --go through all of them
			(
			if fileCountdown == undefined do fileCountdown = theFiles.count -- Set the countdown to the number of files to go through
			print ((fileCountdown as string) + " files left until finished.")
			print ("Current file is: " + (f as string))
			fileCountdown -= 1 -- Increment it down
				
			loadMaxFile f useFileUnits:true quiet:true --load the next file
			-----	
			if fixMats == true do fixAllMat()
			-----
			saveMaxFile f --save the file back to disk
		)--end f loop
	)--end if
	
) -- end if doBatch = true


else if doBatch == false then 
	(
		print "herp derp"
	if fixMats == true do fixAllMat()
	) -- end if doBatch = false

scriptEnded()
)


	
fn scriptEnded = --to run at end of script
(
	enableSceneRedraw() 
	if doBatch == true do (resetMaxFile #noPrompt) -- reset max 
) --end scriptEnded

fn fixAllMat = --fixes spec and diffuse on each material and multimaterial using fixMat() and FixMultiMat() 
(
	mat = sceneMaterials.count
	num=0
	--print mat

	for i=1 to mat do
	(
		myMatClass = classof sceneMaterials[i]
		a = sceneMaterials[i].name

		aA = "a string"
		--print "and now check ifs"
		if (aA == "Bitmap") then (print "aA is a Bitmap")
		else if myMatClass == MultiMaterial then
		(
		--print "it is multi"
		multiMat = sceneMaterials[i].materialList.count
		for j=1 to multiMat do
			(
			fixMultiMat i j	 
			) -- end j loop
		) -- end if MultiMaterial

		else if myMatClass == Mtl then 
		(
		--print "it is Mtl"
		fixMat i
		)
		else if myMatClass == Standardmaterial then 
		(
		--print "it is Standardmaterial"
		fixMat i
		)
		else (
		--print "dunno what to do"
		)
		
		
		case (myMatClass) of
		(
			StandardMaterial:
			(
				if indexMat == true then
				(
					sceneMaterials[i].name = setMatIndex sceneMaterials[i].name num
					num+=1
				)
			)
			MultiMaterial:
			(
				if indexMat == true then
				(
					for k=1 to sceneMaterials[i].materialList.count do
					(
						sceneMaterials[i].materialList[k].name = setMatIndex sceneMaterials[i].materialList[k].name num
						num+=1
					)
				)
			)
			default:
			(
				return ("The material is not a Standard- nor a Multi- material: " + (myMatClass as string))
			)
		)			
	) -- end for
) -- end fixAllMat

fn fixMat a = --fixes spec and diffuse in a material
(
	--print sceneMaterials[a]
	sceneMaterials[a].specular = (color 0 0 0)
    sceneMaterials[a].diffuse = (color 255 255 255)
) --end fixmat

fn fixMultiMat a b = --fixes spec and diffuse in a submaterial of a multimaterial
(
   --print sceneMaterials[a].materialList[b]
   sceneMaterials[a].materialList[b].specular = (color 0 0 0)
   sceneMaterials[a].materialList[b].diffuse = (color 255 255 255)
) -- end fixmultimat
   
fn setMatIndex mname index =
	--	Returns the 'mname' string ending with " [<index>]"
	--	Used in the CAL3D Material names ("<material_name> [<index>]")
(
	idx = mname.count
	if mname[idx]=="]" then
	(
			while (idx>0) and (mname[idx]!="[") do idx-=1
			idx = amax #(1, idx-1)
			while (idx>0) and (mname[idx]==" ") do idx-=1
	)
	return ((substring mname 1 idx) + " [" + (index as string) + "]")
)

setMatScript()